<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) {
    exit;
  }

  // Preorder URL
  $preorder = BMI_AUTHOR_URI;

?>

<div class="mm mt mbl f20">
  <?php _e("Select all the storage options you want to use:", 'backup-backup'); ?>
</div>

<div class="mm60">
  <div class="mm tilo">

    <div class="tab2">

      <!-- Locally start -->
    	<div class="tab2-item d-flex jst-sb ia-center activeList">
    		<div class="d-flex ia-center">
          <img src="<?php echo $this->get_asset('images', '002-monitor-white.svg') ?>" alt="logo" class="tab2-img">
          <span class="ml25">
            <span class="title_whereStored"><?php _e("Locally", 'backup-backup'); ?></span>
            <?php _e("(on this web server)", 'backup-backup'); ?>
          </span>
        </div>
    		<div class="ia-center">
    			<!-- <div class="b2 bmi-switch"><input type="checkbox" checked class="checkbox storage-checkbox" data-toggle="storage-locally-row">
    				<div class="bmi-knobs"><span></span></div>
    				<div class="bmi-layer_str"></div>
    			</div> -->
    		</div>
    	</div>
    	<div class="bg_grey" id="storage-locally-row">
    		<div class="container-40 lh30 pt30 pb30">
    			<div class="d-flex">
    				<div class="w270" style="margin-top: 23px;"><span><?php _e("Backup directory path:", 'backup-backup'); ?></span></div>
    				<div>
    					<div class="w100 pos-r"><input type="text" id="bmi_path_storage_default" placeholder="<?php _e("Enter directory path", 'backup-backup'); ?>" class="input-locally_web_server" value="<?php echo sanitize_text_field(bmi_get_config('STORAGE::LOCAL::PATH')); ?>">
    						<!---->
    					</div>
    					<div class="mt10"><span>
    							<?php _e("That’s where your local backups will be stored. If you picked external storage this folder will also be used (to store your backup temporarily, until it is uploaded to the external storage).", 'backup-backup'); ?>
    						</span></div>
    				</div>
    			</div>
    			<div class="d-flex">
    				<div class="w270" style="margin-top: 23px;"><span><?php _e("Accessible via direct link?", 'backup-backup'); ?></span></div>
    				<div>
    					<div class="w100">
    						<div class="d-flex mr60 ia-center" style="margin-top: 23px;">

                  <label class="container-radio">
                    <?php _e("No", 'backup-backup'); ?>
    								<input type="radio" name="radioAccessViaLink" value="false"<?php echo (bmi_get_config('STORAGE::DIRECT::URL') === 'false')?' checked':'' ?>>
                    <span class="checkmark-radio"></span>
                  </label>

                  <label class="container-radio ml25">
                    <?php _e("Yes", 'backup-backup'); ?>
    								<input type="radio" name="radioAccessViaLink" value="true"<?php echo (bmi_get_config('STORAGE::DIRECT::URL') === 'true')?' checked':'' ?>>
                    <span class="checkmark-radio"></span>
                  </label>

                </div>
    					</div>
    					<div class="mt10">
                <span>
    							<?php _e('Select “Yes” if you want your (manually created) backups to be available via a direct link. This makes migration from one site to another super-fast.', 'backup-backup'); ?>
    						</span>
              </div>
    				</div>
    			</div>
    		</div>
    	</div>

      <?php
        if (has_action('bmi_pro_google_drive_template')) {
          do_action('bmi_pro_google_drive_template');
        } else {
      ?>
      <div class="tab2-item">
        <div class="already_ready"></div>
        <div class="bg_clock_day2">
          <img src="<?php echo $this->get_asset('images', 'premium.svg') ?>" alt="crown" class="crown_img" height="30px" width="30px">
          <?php echo BMI_ALREADY_IN_PRO; ?>
        </div>
        <div class="d-flex ia-center">
          <img src="<?php echo $this->get_asset('images', 'google-drive.svg') ?>" alt="logo" class="tab2-img"> <span class="ml25 title_whereStored">Google Drive</span>
          <img src="<?php echo $this->get_asset('images', 'premium.svg') ?>" alt="logo" class="crown2">
        </div>
        <div class="ia-center">
          <div class="b2 bmi-switch"><input type="checkbox" disabled="disabled" class="checkbox">
            <div class="bmi-knobs"><span></span></div>
            <div class="bmi-layer_str"></div>
          </div>
        </div>
      </div>
      <?php } ?>

        <?php
        if (has_action('bmi_pro_ftp_template')) {

            do_action('bmi_pro_ftp_template');
        } else {
            ?>
            <div class="tab2-item">
                <div class="not_ready"></div>
                <div class="bg_clock_day2"><img src="<?php echo $this->get_asset('images', 'clock2.svg') ?>" alt="clock" class="clock_img" height="30px" width="30px">
                    <?php echo BMI_COMMING_SOON_FREE; ?>
                </div>
                <div class="d-flex ia-center"><img src="<?php echo $this->get_asset('images', 'ftp.svg') ?>" alt="logo" class="tab2-img"> <span class="ml25 title_whereStored">FTP</span></div>
                <div class="ia-center">
                    <div class="b2 bmi-switch"><input type="checkbox" disabled="disabled" class="checkbox">
                        <div class="bmi-knobs"><span></span></div>
                        <div class="bmi-layer_str"></div>
                    </div>
                </div>
            </div>
        <?php } ?>

      <?php
        if (has_action('bmi_pro_other_storage_options')) {
          do_action('bmi_pro_other_storage_options');
        } else {
      ?>
      <div class="tab2-item">
        <div class="not_ready"></div>
        <div class="bg_clock_day2"><img src="<?php echo $this->get_asset('images', 'clock2.svg') ?>" alt="clock" class="clock_img" height="30px" width="30px">
          <?php echo BMI_COMMING_SOON_PRO; ?>
        </div>
        <div class="d-flex ia-center">
          <img src="<?php echo $this->get_asset('images', 'google-cloud.svg') ?>" alt="logo" class="tab2-img"> <span class="ml25 title_whereStored">Google Cloud</span>
          <img src="<?php echo $this->get_asset('images', 'premium.svg') ?>" alt="logo" class="crown2">
        </div>
        <div class="ia-center">
          <div class="b2 bmi-switch"><input type="checkbox" disabled="disabled" class="checkbox">
            <div class="bmi-knobs"><span></span></div>
            <div class="bmi-layer_str"></div>
          </div>
        </div>
      </div>
      <div class="tab2-item">
        <div class="not_ready"></div>
        <div class="bg_clock_day2"><img src="<?php echo $this->get_asset('images', 'clock2.svg') ?>" alt="clock" class="clock_img" height="30px" width="30px">
          <?php echo BMI_COMMING_SOON_FREE; ?>
        </div>
        <div class="d-flex ia-center"><img src="<?php echo $this->get_asset('images', 'ftp.svg') ?>" alt="logo" class="tab2-img"> <span class="ml25 title_whereStored">FTP</span></div>
        <div class="ia-center">
          <div class="b2 bmi-switch"><input type="checkbox" disabled="disabled" class="checkbox">
            <div class="bmi-knobs"><span></span></div>
            <div class="bmi-layer_str"></div>
          </div>
        </div>
      </div>
      <div class="tab2-item">
        <div class="not_ready"></div>
        <div class="bg_clock_day2"><img src="<?php echo $this->get_asset('images', 'clock2.svg') ?>" alt="clock" class="clock_img" height="30px" width="30px">
          <?php echo BMI_COMMING_SOON_PRO; ?>
        </div>
        <div class="d-flex ia-center"><img src="<?php echo $this->get_asset('images', 'sftp-scp.svg') ?>" alt="logo" class="tab2-img"> <span class="ml25 title_whereStored">SFTP / SCP</span> <img src="<?php echo $this->get_asset('images', 'premium.svg') ?>"
            alt="logo" class="crown2"></div>
        <div class="ia-center">
          <div class="b2 bmi-switch"><input type="checkbox" disabled="disabled" class="checkbox">
            <div class="bmi-knobs"><span></span></div>
            <div class="bmi-layer_str"></div>
          </div>
        </div>
      </div>
      <div class="tab2-item">
        <div class="not_ready"></div>
        <div class="bg_clock_day2"><img src="<?php echo $this->get_asset('images', 'clock2.svg') ?>" alt="clock" class="clock_img" height="30px" width="30px">
          <?php echo BMI_COMMING_SOON_FREE; ?>
        </div>
        <div class="d-flex ia-center"><img src="<?php echo $this->get_asset('images', 'Amazon.svg') ?>" alt="logo" class="tab2-img"> <span class="ml25 title_whereStored">Amazon S3</span></div>
        <div class="ia-center">
          <div class="b2 bmi-switch"><input type="checkbox" disabled="disabled" class="checkbox">
            <div class="bmi-knobs"><span></span></div>
            <div class="bmi-layer_str"></div>
          </div>
        </div>
      </div>
      <div class="tab2-item">
        <div class="not_ready"></div>
        <div class="bg_clock_day2"><img src="<?php echo $this->get_asset('images', 'clock2.svg') ?>" alt="clock" class="clock_img" height="30px" width="30px">
          <?php echo BMI_COMMING_SOON_PRO; ?>
        </div>
        <div class="d-flex ia-center"><img src="<?php echo $this->get_asset('images', 'microsoft-azure.svg') ?>" alt="logo" class="tab2-img"> <span class="ml25 title_whereStored">Microsoft Azure</span> <img src="<?php echo $this->get_asset('images', 'premium.svg') ?>"
            alt="logo" class="crown2"></div>
        <div class="ia-center">
          <div class="b2 bmi-switch"><input type="checkbox" disabled="disabled" class="checkbox">
            <div class="bmi-knobs"><span></span></div>
            <div class="bmi-layer_str"></div>
          </div>
        </div>
      </div>
      <div class="tab2-item">
        <div class="not_ready"></div>
        <div class="bg_clock_day2"><img src="<?php echo $this->get_asset('images', 'clock2.svg') ?>" alt="clock" class="clock_img" height="30px" width="30px">
          <?php echo BMI_COMMING_SOON_PRO; ?>
        </div>
        <div class="d-flex ia-center"><img src="<?php echo $this->get_asset('images', 'onedrive.svg') ?>" alt="logo" class="tab2-img"> <span class="ml25 title_whereStored">OneDrive</span> <img src="<?php echo $this->get_asset('images', 'premium.svg') ?>"
            alt="logo" class="crown2"></div>
        <div class="ia-center">
          <div class="b2 bmi-switch"><input type="checkbox" disabled="disabled" class="checkbox">
            <div class="bmi-knobs"><span></span></div>
            <div class="bmi-layer_str"></div>
          </div>
        </div>
      </div>
      <div class="tab2-item">
        <div class="not_ready"></div>
        <div class="bg_clock_day2"><img src="<?php echo $this->get_asset('images', 'clock2.svg') ?>" alt="clock" class="clock_img" height="30px" width="30px">
          <?php echo BMI_COMMING_SOON_FREE; ?>
        </div>
        <div class="d-flex ia-center"><img src="<?php echo $this->get_asset('images', 'rackspace.svg') ?>" alt="logo" class="tab2-img"> <span class="ml25 title_whereStored">Rackspace</span></div>
        <div class="ia-center">
          <div class="b2 bmi-switch"><input type="checkbox" disabled="disabled" class="checkbox">
            <div class="bmi-knobs"><span></span></div>
            <div class="bmi-layer_str"></div>
          </div>
        </div>
      </div>
      <div class="tab2-item">
        <div class="not_ready"></div>
        <div class="bg_clock_day2"><img src="<?php echo $this->get_asset('images', 'clock2.svg') ?>" alt="clock" class="clock_img" height="30px" width="30px">
          <?php echo BMI_COMMING_SOON_PRO; ?>
        </div>
        <div class="d-flex ia-center"><img src="<?php echo $this->get_asset('images', 'backblaze.svg') ?>" alt="logo" class="tab2-img"> <span class="ml25 title_whereStored">Backblaze</span> <img src="<?php echo $this->get_asset('images', 'premium.svg') ?>"
            alt="logo" class="crown2"></div>
        <div class="ia-center">
          <div class="b2 bmi-switch"><input type="checkbox" disabled="disabled" class="checkbox">
            <div class="bmi-knobs"><span></span></div>
            <div class="bmi-layer_str"></div>
          </div>
        </div>
      </div>
      <div class="tab2-item">
        <div class="not_ready"></div>
        <div class="bg_clock_day2"><img src="<?php echo $this->get_asset('images', 'clock2.svg') ?>" alt="clock" class="clock_img" height="30px" width="30px">
          <?php echo BMI_COMMING_SOON_FREE; ?>
        </div>
        <div class="d-flex ia-center"><img src="<?php echo $this->get_asset('images', 'dream-objects.svg') ?>" alt="logo" class="tab2-img"> <span class="ml25 title_whereStored">DreamObjects</span></div>
        <div class="ia-center">
          <div class="b2 bmi-switch"><input type="checkbox" disabled="disabled" class="checkbox">
            <div class="bmi-knobs"><span></span></div>
            <div class="bmi-layer_str"></div>
          </div>
        </div>
      </div>
      <div class="tab2-item">
        <div class="not_ready"></div>
        <div class="bg_clock_day2"><img src="<?php echo $this->get_asset('images', 'clock2.svg') ?>" alt="clock" class="clock_img" height="30px" width="30px">
          <?php echo BMI_COMMING_SOON_FREE; ?>
        </div>
        <div class="d-flex ia-center"><img src="<?php echo $this->get_asset('images', 'openstack-swift.svg') ?>" alt="logo" class="tab2-img"> <span class="ml25 title_whereStored">Openstack (Swift)</span></div>
        <div class="ia-center">
          <div class="b2 bmi-switch"><input type="checkbox" disabled="disabled" class="checkbox">
            <div class="bmi-knobs"><span></span></div>
            <div class="bmi-layer_str"></div>
          </div>
        </div>
      </div>
    <?php } ?>
    </div>
  </div>
</div>

<?php include BMI_INCLUDES . '/dashboard/chapter/save-button.php'; ?>
