<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

?>

<div class="bmi-modal" id="prenotice-modal">

  <div class="bmi-modal-wrapper no-hpad" style="max-width: 660px; max-width: min(660px, 80vw);">
    <a href="#" class="bmi-modal-close">×</a>
    <div class="bmi-modal-content">

      <div class="mm60 f26 medium black"><?php _e('We noticed:', 'backup-backup') ?></div>
      <div class="prenotices">

        <div class="prenotice red prenotic-1">
          <div class="text">
            <?php _e('You running quite low on space. Maybe it would be good to clear up some space before you do the backup.', 'backup-backup') ?> 
          </div>
        </div>
        <div class="prenotice prenotic-2">
          <div class="text">
            <?php _e('You may not have enough memory (RAM) to create the backup. You can still try, if it fails check out the troubleshooting section.', 'backup-backup') ?>
          </div>
        </div>
        <div class="prenotice prenotic-3">
          <div class="text">
            <?php _e('Based on your selections ', 'backup-backup') ?>
            <span id="prenotice-size"></span><?php _e(' of data (unzipped) will be backed up.', 'backup-backup') ?>
          </div>
        </div>
        <div class="prenotice prenotic-4">
          <div class="text">
            <?php _e('You selected to only back up part of your site (not a complete backup).', 'backup-backup') ?>
          </div>
        </div>
        <div class="prenotice prenotic-5">
          <div class="text">
            <?php _e('You selected only files for backup - without database.', 'backup-backup') ?>
          </div>
        </div>
        <div class="prenotice prenotic-6">
          <div class="text">
            <?php _e('You selected only database to backup - without website files.', 'backup-backup') ?>
          </div>
        </div>

      </div>
      <div class="mm60 center">
        <a href="#" class="btn btn-with-img" id="start-entire-backup">
          <div class="text">
            <img style="margin-top: 1px;" src="<?php echo $this->get_asset('images', 'backup-min.svg'); ?>" alt="server-img" class="img-now">
            <div class="f18 regular"><?php _e('That’s all fine / I don’t care…', 'backup-backup') ?></div>
            <div class="f25 bold"><?php _e('Create the backup!', 'backup-backup') ?></div>
          </div>
        </a>
        <div class="text-grey text-muted mtl f18 bmi-modal-closer inline" data-close="prenotice-modal">
          <?php _e('Don’t do backup & close this pop-up', 'backup-backup') ?>
        </div>
      </div>

    </div>
  </div>

</div>
